﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;

namespace GeneratorWerIntKodu
{
   internal class WsparcieMD5
   {
      public const string wzorzecTekstPoczątek = "XXX_BEGIN_WZORZEC_MD5";
      public const string wzorzecTekstKoniec = "XXX_END_WZORZEC_MD5";

      // Postać binarna fragmentów stałej: XXX_BEGIN_WZORZEC_MD5_ i _XXX_END_WZORZEC_MD5
      public const string wzorzecBinPoczątek = "X" + "\0" + "X" + "\0" + "X" + "\0" + "_" + "\0" + "B" + "\0" + "E" + "\0" + "G" +
                           "\0" + "I" + "\0" + "N" + "\0" + "_" + "\0" + "W" + "\0" + "Z" + "\0" + "O" + "\0" + "R" + "\0" +
                           "Z" + "\0" + "E" + "\0" + "C" + "\0" + "_" + "\0" + "M" + "\0" + "D" + "\0" + "5" + "\0" + "_" + "\0";
      public const string wzorzecBinKoniec = "_" + "\0" + "X" + "\0" + "X" + "\0" + "X" + "\0" + "_" + "\0" + "E" + "\0" + "N" +
                           "\0" + "D" + "\0" + "_" + "\0" + "W" + "\0" + "Z" + "\0" + "O" + "\0" + "R" + "\0" +
                           "Z" + "\0" + "E" + "\0" + "C" + "\0" + "_" + "\0" + "M" + "\0" + "D" + "\0" + "5" + "\0";

     
      public string MD5Metody(MethodInfo aMethodInfo)
      {
         MethodBody mb = aMethodInfo.GetMethodBody();
         byte[] kodMetody = mb.GetILAsByteArray();
         return MD5OfBytes(kodMetody);
      }

      public string WzorzecMD5()
      {
         return wzorzecMD5App.Replace(wzorzecTekstPoczątek + "_", "").Replace("_" + wzorzecTekstKoniec, "");
      }

      // Przygotowany wzorzec MD5 aplikacji, 32 zera odpowiadają długością wartości MD5, która powinna być wyznaczona przez inny program
      private const string wzorzecMD5App = "XXX_BEGIN_WZORZEC_MD5_00000000000000000000000000000000_XXX_END_WZORZEC_MD5";

      private string MD5OfBytes(byte[] zawartość)
      {
         string wartMD5 = "";
         System.Security.Cryptography.MD5CryptoServiceProvider x = new System.Security.Cryptography.MD5CryptoServiceProvider();
         zawartość = x.ComputeHash(zawartość);
         for (int i = 0; i < zawartość.Length; i++)
            wartMD5 += zawartość[i].ToString("x2").ToLower();
         return wartMD5;
      }

   }
}
